//*****************************************************************
//  (c) BMD Systemhaus Software
//*****************************************************************
// Name:        tools.js
// Owner:       SPH001
// Project:     80055
//*****************************************************************


//*****************************************************************
// Deklarationen globaler Variablen
//*****************************************************************

var GActiveArrowNavigation = false;
var GSendArrowNavToServer = false;
var GBlockCursor = false;
var GBtnClicked = false;
var GMouseClicked = false;
var GMultiSelectActive = false;
var GFocusColor = "#FFFF80";
var GSelectedRowColor ="#A6CAF0";
var GLastGridControlName;
var cltimer = null;
var GKeyCode = -1;  //KeyCode >= 0 Taste (Tab, Enter), KeyCode = -1 Mouse-Aktion
var GShiftState = 0;
var docShortcuts = null;
var ctrlsRegExp = null;
var ctrlsMsgs = null;
var ctrlsCS = null;
var GCloseAction = null;
var selectedRows = null;
var GRecNoDecSpaces;
var GIsPartialUpdate;
var GShowJSErrors = false;
var GUseAjax = false;

//******************************************************************************
// IE only
// standardmig ist in der Internetzone die Mglichkeit gesperrt die
// Statuszeile umzusetzen. Das wird hier als Prfung der eingestellten Zone
// mibraucht
//******************************************************************************
function BMDCheckSecurityZone(ErrorText) {
var elItem1, elItem2, statusString;
  if(document.all){ //nur IE
    try {
      statusString = top.status; 
      
      top.status = 'checkZone';
      
      elItem1 = new BMDGetElemById('PNLERROR');
     
      elItem2 = new BMDGetElemById('LBLERROR');
      if (elItem2 && ((top.status) == 'checkZone')) {
        elItem2.innerHTML = '';
        if (elItem1) {
          try {
            elItem1.style.visibility = "hidden";
          } catch(e) {
            //Do nothing
          }
        }        
      } else {
        elItem2.innerHTML = ErrorText;
      }
      
      top.status = statusString;
    } catch(e) {
      //Do nothing
    }
  }    
}

//*****************************************************************
// Sammelinitialisierungsfunknion
// experimentell
//*****************************************************************
function BMDInitIWCLControl(HTMLName, parentName, clientSideControl) {
  eval(HTMLName + 'IWCL = CreateIWCLObject("' + parentName + '", "' + HTMLName + '", "' + HTMLName + 'IWCL");');
}

function BMDUpdateControl(HTMLName, visible, left, top, width, height, alignment) {
  eval('if (' + HTMLName + 'IWCL) {SetVisibility(window.parent.' + HTMLName + 'IWCL, ' + visible + ');IWTop().' + HTMLName + 'IWCL.' + visible + '();IWTop().' + HTMLName + 'IWCL.' + 'OriginalRect = new parent.Rect(' + left + ',' + top + ',' + width + ',' + height + ');');
  eval('if (' + HTMLName + 'IWCL) {' + HTMLName + 'IWCL.SetAlign(' + alignment + ');');
}

function Mod(div,base) {
  return Math.round(div - (Math.floor(div/base)*base));
}

function sortNumber(a, b) {
  return a - b;
}


//*****************************************************************
// liefert HiddenField als Element zurck
//*****************************************************************
function BMDGetHiddenField(Id) {
var elCol, elItem, res, elGSubItem;
  res = null;
  //elItem = FindElem(Id);
  //elItem = GSubmitter.elements.document.getElementById(Id);
  elItem = new BMDGetElemById(Id);
  //elItem = FindSubmitElement(Id);
  if (elItem) {
   res = elItem;
  }
  return res;
}

//*****************************************************************
// liefert Wert eines HiddenFields zurck
//*****************************************************************
function BMDGetHiddenFieldVal(Id) {
var elItem, res;
  res = null;
  elItem = new BMDGetHiddenField(Id);
  if (elItem) {
   res = elItem.value;
  }
  return res;
}

//*****************************************************************
// hngt Feld an ChangedControls des Forms an
//*****************************************************************
function BMDAddToChangedControls(Id) {
  if (GUseAjax) {  
    if (!containsName(Id)) {
      window.ChangedControls += Id + ",";
    }
  }
  return true;  
}

//*****************************************************************
// setzt Wert eines HiddenFields
//*****************************************************************
function BMDSetHiddenFieldVal(Id, value) {
var elItem;
  elItem = new BMDGetHiddenField(Id);
  try {
    if (elItem) { 
      
      if (value && (value != "@undefined")) {
        
        //wenn z.B. ActualControl gesetzt werden soll, '_CHECKBOX' entfernen
        try {
          if (value.indexOf("_CHECKBOX") >= 0) {
            value = value.replace(/_CHECKBOX/,"");
          }
        } catch (e) {
          //if (GShowJSErrors) { alert("Exception in BMDSetHiddenFieldVal(CHECKBOX):" + e.message) };
        }
      }

      elItem.value = value;
      
      BMDAddToChangedControls(Id);
      
      return true;
    } else {
     return false;
    }
  } catch (e) {
    if (GShowJSErrors) { alert("Exception in BMDSetHiddenFieldVal:" + e.message); }
    return false;
  }
}

//*****************************************************************
// wartet die Dauer der angegebenen Millisekunden
//*****************************************************************
function BMDWaitMS(milliseconds) {
var date = new Date();
  while (1) {
    mill = new Date();
    diff = mill-date;
    if( diff > milliseconds ) {
      break;
    }
  }
}

//*****************************************************************
// prft ob String in Array vorhanden
//*****************************************************************
function BMDArrayContains(array, value) {
  for (var i = 0; i < array.length; ++i) {
    if (array[i] === value) {
      return true;
    }
  }
  return false;
}

//*****************************************************************
//
//*****************************************************************
function BMDSwitchCheckBox(elName) {
var elemCB, elem;
  elemCB = new BMDGetElemById(elName + '_CHECKBOX');
  elem = new BMDGetElemById(elName);
  if (elem) {
    elem.value = elemCB.checked ? "1" : "0";
    if ((BMDGetHiddenFieldVal("HD" + elName) != elem.value) && (GKeyCode != 27)) {
      BMDSetHiddenFieldVal("HD" + elName, '@' + elem.value);
    }      
  }
}

//*****************************************************************
// wird beim Klick einer CheckBox ausgefhrt
//*****************************************************************
function BMDSetCheckBox(evt, elName) {
var elemCB; 
  if ((ctrlsCS !== null) && BMDArrayContains(ctrlsCS, elName.toUpperCase())) {
    BMDSwitchCheckBox(elName);
  } else {
    elemCB = new BMDGetElemById(elName + '_CHECKBOX');
    BMDSubmit(evt, elemCB); 
  }
}

//*****************************************************************
// prft ob String in Array vorhanden
//*****************************************************************
function BMDGetArrayIndex(array, value) {
var i, result;
  i = 0;
  result = -1;
  while((result == -1) && (i < array.length)){
    if (array[i] == value) {
      result = i;
    }
    i++;
  }
  return result;
}

//*****************************************************************
// Abfrage vor Schliessen des Fensters
//*****************************************************************
function BMDOnCloseWindow(evt) {
  if (!evt) {var evt = window.event};
  if(self.VBArray){
    var s = self.screen;
    if(evt !== null && s !== null){
      if(evt.clientX + s.width < 0 && evt.clientY + s.height < 0){
        if (GCloseAction) {
          BMDStartDelphiAction(GCloseAction);
          BMDWaitMS(500);
        }
      }
    }
  }
}

//*****************************************************************
// sucht das erste Parent-Element mit table-tag
//*****************************************************************
function BMDGetParentTable(elem) {
var res;
var parentElem;
  res = null;
  if (elem) {
    parentElem = elem.parentElement;
    while ((res === null) && (parentElem != elem.parentWindow)) {
      if (parentElem) {
        if ((parentElem.tagName == 'table') || (parentElem.tagName == 'TABLE')) {
          res = parentElem;
        }
        parentElem = parentElem.parentElement;
      }
    }
  }
  return res;
}

//*****************************************************************
// liefert Parent-Grid fr beliebiges Element
//*****************************************************************
function BMDGetGridIdForElem(elem) {
var tableElem;
var res;
  res = '';
  tableElem = BMDGetParentTable(elem);
  if (tableElem && tableElem.id) {
    //res = tableElem.id.substr(3);  //'tbl'-Prefix abschneiden
    res = tableElem.id;
  }
  return res;
}

//*****************************************************************
// wird von Buttons aufgerufen, damit Aktionen vor Submit ausge-
// fhrt werden knnen
// Spter wieder einbauen : steuert Verhalten beim Fokusverlust
// eines Felds durch Drcken eines Buttons
//*****************************************************************
function BMDButtonClick(evt, sender) {
var elem = null;
  if (!evt) {var evt = window.event;}
  GBtnClicked = true;

  elem = document.activeElement;  //funktioniert nur unter IE
  if (elem) {
    BMDSetHiddenFieldVal("ACTUALCONTROL",    elem.id);
    BMDSetHiddenFieldVal("ACTUALCONTROLVAL", elem.value);
  }

  if (selectedRows) {
    BMDSetHiddenFieldVal("SELECTEDROWS", selectedRows.join("|"));
  } else {
    BMDSetHiddenFieldVal("SELECTEDROWS", "");
  }
  return !GBlockCursor;
}

//*****************************************************************
function BMDHandleMouseClick(evt) {
var elem = null;
  BMDCancelBubble(evt);

  if (!evt) {var evt = window.event;}
  elem = (evt.target) ? evt.target : evt.srcElement;
  if ((elem) && (elem.id !== undefined)) {
    if (elem.id != "") {
      BMDSetHiddenFieldVal("CLICKEDCONTROL", elem.id);
    } else {
      if (elem.parentNode) {  //z.B. Comboboxen in FF
        BMDSetHiddenFieldVal("CLICKEDCONTROL", elem.parentNode.id);  
       }      
    }
    GMouseClicked = true;
  } else {
    BMDSetHiddenFieldVal("CLICKEDCONTROL", "");
    GMouseClicked = false;
  }
  if (selectedRows) {
    BMDSetHiddenFieldVal("SELECTEDROWS", selectedRows.join("|"));
  } else {
    BMDSetHiddenFieldVal("SELECTEDROWS", "");
  }
  return true;
}

//*****************************************************************
// wird von jedem Control ausgefhrt, nur noch fr Setzen der
// Fokusfarbe benutzt, wenn Controls keine Hintergrundeigenschaft
// haben, wird Exception abgefangen
//*****************************************************************
function BMDChangeFocus(sender, onfocus, dosubmit) {
var res = !GBlockCursor;
  if(onfocus) {
    try {
      sender.style.backgroundColor = GFocusColor;
    } catch (e) {
      if (GShowJSErrors) { alert("Exception in BMDChangeFocus:" + e.message); }
    }
    return res;
  } else {
    try {
      BMDSetHiddenFieldVal("ACTUALCONTROL", sender.id);
      BMDSetHiddenFieldVal("ACTUALCONTROLVAL", sender.value);
      if (selectedRows) {
        BMDSetHiddenFieldVal("SELECTEDROWS", selectedRows.join("|"));
      } else {
        BMDSetHiddenFieldVal("SELECTEDROWS", "");
      }
      
      //Checkboxen werden andernorts abgehandelt (BMDSetCheckBox)
      if (sender.type != "checkbox") {
        BMDSetChangedValue(sender);
      }      
        
      sender.style.backgroundColor = '#FFFFFF';
    } catch (e) {
      if (GShowJSErrors) { alert("Exception in BMDChangeFocus:" + e.message); }
    }
    return res;
  }
}

//*****************************************************************
function BMDSetChangedValue(sender) {
  if ((BMDGetHiddenField("HD" + sender.id)) && (sender.value || sender.value == '') && (GKeyCode != 27) ) {
    if (BMDGetHiddenFieldVal("HD" + sender.id) != sender.value) {
      BMDSetHiddenFieldVal("HD" + sender.id, '@' + sender.value);
    }
  }	
}

//*****************************************************************
// Click auf das Grid per Ajax weiterreichen
//*****************************************************************
function BMDOnClickGrid(evt, objname, param) {
var elem = null;
var elemname;
var regEx;
var regExRes;
 
  BMDSetHiddenFieldVal("PAGENAVTO", param);

  if (!evt) {var evt = window.event;}
  elem = (evt.target) ? evt.target : evt.srcElement;
 
  if ((elem) && (elem.id !== undefined)) {
      regEx = new RegExp('^\d+_\d+_(.*)$', "g");
      if (regEx.test(elem.id)) {
        regExRes = regEx.exec(elem.id);
        try {
          elemname = regExRes[1];
          BMDSetHiddenFieldVal("CLICKEDCONTROL", elemname);    
          GMouseClicked = true;          
        } catch(e) {
        
        }
      }
  } else {
    //BMDSetHiddenFieldVal("CLICKEDCONTROL", "");
    //GMouseClicked = false;
  }

  if (GUseAjax) {  
    processAjaxEvent(event, objname + "IWCL", objname + ".DoOnAsyncChange", true, null, false);
  } else {
    SubmitClickConfirm(objname, param, false, '');  
  }
}

//*****************************************************************
// passt Bltternavigation an Zeilennavigation an
//*****************************************************************
function BMDSubmitPageNav(objname, param, ADoValidation, AConfirmation) {
var relativeRowId = 0;
var newRowId      = 0;
var paramRowId    = 0;
var actualRowId   = 0;
var firstRowId    = 0;
var rowLimit      = 0;
var newtopRowId	  = 0;
  paramRowId = parseInt(param.substr(6));
  if (!isNaN(paramRowId) && (parseInt(BMDGetHiddenFieldVal("HDACTUALROWID")) != paramRowId)) {
    firstRowId  = parseInt(BMDGetHiddenFieldVal("HDFIRSTROWID"));
    actualRowId = parseInt(BMDGetHiddenFieldVal("HDACTUALROWID"));
    rowLimit    = parseInt(BMDGetHiddenFieldVal("HDROWLIMIT"));
    if (!(isNaN(rowLimit) || isNaN(actualRowId))) {
      newtopRowId = paramRowId - Mod(paramRowId, rowLimit);
      newRowId    = newtopRowId + Mod(actualRowId, rowLimit);
      param = "NavTo_" + newRowId;
    }
  }
  if (selectedRows) {
    BMDSetHiddenFieldVal("SELECTEDROWS", selectedRows.join("|"));
  } else {
    BMDSetHiddenFieldVal("SELECTEDROWS", "");
  }
  
  BMDSetHiddenFieldVal("PAGENAVTO", param);  
  if (GUseAjax) {
    processAjaxEvent(event, objname, objname + ".DoOnAsyncChange", true, null, false);
  } else {
    SubmitClickConfirm(objname, param, ADoValidation, AConfirmation);
  }
}

//*****************************************************************
// Checkbox unter SPAN zurckliefern
//*****************************************************************
function BMDGetCheckBox(parentElement) {
var i, res, elCol, elItem;
  res = parentElement;
  try {
    elCol = parentElement.childNodes;
    for (i=0; i<(elCol.length); i++) {
      elItem = elCol(i);
      if (elItem.type == "checkbox") {
        res = elItem;
      }
    }
  } catch (e) {
    if (GShowJSErrors) { alert("Exception in BMDGetCheckBox:" + e.message); }
  }
  return res;
}

//*****************************************************************
function BMDClickAndSubmit(id) {
  BMDGetElemById(id).click();
  ReleaseLock();  //sonst wird der Submit abgebrochen
  SubmitClickConfirm(id, "", true, "");
}

//*****************************************************************
function BMDLoginClick(evt, sender) {
  try {
    document.body.style.cursor = "wait";
    
    elemUser  = BMDGetElemById("EDUSR");
    elemPass  = BMDGetElemById("EDPASS");
    elemClient = BMDGetElemById("EDCLIENTNO");
    
    if ((GPublicKey != "") && elemUser && elemPass) {
      valUser  = elemUser.value;
      valPass  = elemPass.value;
      
      if (elemClient) {
        valClient  = elemClient.value;
      }     
      
      var encrypt = new JSEncrypt();
      encrypt.setPublicKey(GPublicKey);
      
      BMDSetHiddenFieldVal("HDDATA1", encrypt.encrypt(valUser));
      BMDSetHiddenFieldVal("HDDATA2", encrypt.encrypt(valPass));
      
      if (elemClient) {
        BMDSetHiddenFieldVal("HDDATA3", encrypt.encrypt(valClient));
        elemClient.value = "";
      }           
      
      elemUser.value = "";
      elemPass.value = "";         
     
    }
  } catch (e) {
  
  }
  return true;
}   

//*****************************************************************
function BMDEncrypt(evt, sender) {
  if (GPublicKey != "") {
    try {    
      var encrypt = new JSEncrypt();
      encrypt.setPublicKey(GPublicKey);
      //sender.value = encrypt.encrypt(sender.value);
      BMDSetHiddenFieldVal(sender.id, encrypt.encrypt(sender.value));
    } catch (e) {
  
    }  
  }  
}

//*****************************************************************
// Zentrales Submit, wird von jedem Control aufgerufen
//*****************************************************************
function BMDSubmit(evt, sender) {
var regEx;
var regExString = "";
var testValue = "";
var lValue = "";

  if (!evt) var evt = window.event;
  GBlockCursor = true;

  if (!GBtnClicked) {
    if ((ctrlsCS != null) && BMDArrayContains(ctrlsCS, sender.id.toUpperCase())) {
      GBlockCursor = false;
      if ((ctrlsRegExp != null) && (sender.id) && (ctrlsRegExp[sender.id.toUpperCase()] != undefined)) {
        testValue = sender.value;
        regExString = ctrlsRegExp[sender.id.toUpperCase()];
        regEx = new RegExp(regExString, "g");
        if (!regEx.test(testValue)) {
	     if ((ctrlsMsgs) && (ctrlsMsgs[sender.id.toUpperCase()] != undefined)) {
            alert(ctrlsMsgs[sender.id.toUpperCase()]);
	          BMDSetFocusToName(sender.id);
            return false;
          }
        }
      }
      return true;
    } else {
      
      //Backslashes 'escapen'
      lValue = sender.value;
      try {
        if (lValue && (lValue.indexOf('\\') >= 0)) {
          lValue = lValue.replace(/\\/g,'\\\\');
        }
      } catch (e) {
        if (GShowJSErrors) { alert("Exception Submit-Backslashes:" + e.message); }       
      }      
              
  	  if (BMDGetHiddenFieldVal("CLICKEDCONTROL")) {

        BMDSetHiddenFieldVal("ACTUALCONTROL", sender.id);
        BMDSetHiddenFieldVal("ACTUALCONTROLVAL", sender.value);
        
        GMouseClicked = false;
       
        setTimeout("SubmitClickConfirm('" + sender.id + "','" + lValue + "','" + true + "','')", 200);
      } else {
        BMDSetHiddenFieldVal("ACTUALCONTROL", sender.id);
        BMDSetHiddenFieldVal("ACTUALCONTROLVAL", sender.value);
        BMDSetHiddenFieldVal("HDKEYCODE", GKeyCode);
        BMDSetHiddenFieldVal("HDSHIFTSTATE", GShiftState);
        if (selectedRows) {
          BMDSetHiddenFieldVal("SELECTEDROWS", selectedRows.join("|"));
        } else {
          BMDSetHiddenFieldVal("SELECTEDROWS", "");
        }
        GKeyCode = -1;
        BMDSetHiddenFieldVal("CLICKEDCONTROL", "");
    
        setTimeout("SubmitClickConfirm('" + sender.id + "','" + lValue + "','" + true + "','')", 200);
        //setTimeout: sonst wird OnClick gar nicht ausgefhrt und CLICKEDCONTROL nicht gesetzt
        //SubmitClickConfirm(sender.id, lValue, true, "");
      }
      return true;
    }
  } else {
    GBtnClicked  = false;
    GBlockCursor = false;
    evt.returnValue = true;
    return true;
  }
}

//*****************************************************************
// liefert Element mit genannter Id zurck
//*****************************************************************
function BMDGetElemById(Id) {
var elItem, res;
  res = null;
  elItem = document.getElementById(Id);
  if (elItem) {
  	res = elItem;
  }
  else {
	try {
		elItem = FindSubmitElement(Id);
	} 
	catch (e) {
		if (GShowJSErrors) {
			alert("Exception in BMDGetElemById(FindSubmitElement):" + e.message);
		}
	}
	if (elItem) {
		res = elItem;
	}
	else {
		try {
			elItem = document.getElementById(Id);
		} 
		catch (e) {
			if (GShowJSErrors) {
				alert("Exception in BMDGetElemById(getElementById):" + e.message);
			}
		}
		if (elItem) {
			res = elItem;
		}
		else {
			try {
				res = document.getElementsByName(Id)[0];
			} 
			catch (e) {
				if (GShowJSErrors) {
					alert("Exception in BMDGetElemById(getElementById):" + e.message);
				}
			}
		}
  	}
  }
  return res;
}

//*****************************************************************
// setzt Elementwert mit Id
//*****************************************************************
function BMDSetElemValById(Id, value) {
var elItem;
  elItem = BMDGetElemById(Id);
  if (elItem) {
   elItem.value = value;
   return true;
  } else {
   return false;
  }
}

//*****************************************************************
// liefert Elementwert mit Id
//*****************************************************************
function BMDGetElemValByID(Id) {
var elItem, res;
  res = null;
  elItem = BMDGetElemById(Id);
  if (elItem) {
   res = elItem.value;
  }
  return res;
}

//*****************************************************************
// stsst eine Action in Delphi an
//*****************************************************************
function BMDStartDelphiAction(actPointer) {
  if (selectedRows) {
    selectedRows.sort(sortNumber);
    BMDSetHiddenFieldVal("SELECTEDROWS", selectedRows.join("|"));
  } else {
    BMDSetHiddenFieldVal("SELECTEDROWS", "");
  }
  BMDSetHiddenFieldVal("ACTIONREF", actPointer);
  if (GUseAjax) {
    processAjaxEvent(event, "ACTIONREFIWCL", "ACTIONREF.DoOnAsyncChange", true, null, false);
  } else {
    SubmitClickConfirm("ACTIONREF", actPointer, true, "");
  }  
}

//*****************************************************************
// Multi-Select-Click im Grid
//*****************************************************************
function BMDOnClickRowSelector(evt, rowId) {
var srcElem, elCol, elItem, index;
  if (!evt) var evt = window.event;

  if ((rowId != '') && (rowId != '-1')) {
    if (selectedRows == null) {
      selectedRows = new Array(rowId);
    } else {
      index = BMDGetArrayIndex(selectedRows, parseInt(rowId));
      if (index == -1) {
        selectedRows.push(rowId);
        srcElem = (evt.target) ? evt.target : evt.srcElement;
      } else {
        selectedRows.splice(index, 1);
      }
      try {
        if (srcElem) {
          elCol = srcElem.childNodes;
          if (elCol) {
            for (i=0; i<(elCol.length); i++) {
              elItem = elCol(i);
              if ((elItem) && (elItem.type == 'checkbox')) {
                elItem.click();
              }
            }
          }
        }
      } catch(e) {
        if (GShowJSErrors) { alert("Exception in BMDOnClickRowSelector:" + e.message); }
      }

    }
    BMDCancelBubble(evt);
    return true;
  }
}

//*****************************************************************
// selektiert alle Datenstze (Checkboxen bei MultiSelectActive)
//*****************************************************************
function BMDMultiSelectAll() {
var strfirstRowId, strlastRowId, strrowLimit, firstRowId, lastRowId, rowLimit, i, allSelected;

  strfirstRowId = BMDGetHiddenFieldVal("HDFIRSTROWID");
  strlastRowId  = BMDGetHiddenFieldVal("HDLASTROWID");
  strrowLimit   = BMDGetHiddenFieldVal("HDROWLIMIT");

  allSelected   = true;

  firstRowId = parseInt(strfirstRowId);
  lastRowId  = parseInt(strlastRowId);

  rowLimit   = parseInt(strrowLimit);

  firstRowId = Mod(firstRowId, Math.pow(10, parseInt(GRecNoDecSpaces)));
  lastRowId  = Mod(lastRowId, Math.pow(10, parseInt(GRecNoDecSpaces)));


  //gendert: wenn alle selektiert alle deselektieren, sonst alle selektieren

  if ((firstRowId != NaN) && (lastRowId != NaN) && (rowLimit != NaN)) {
    for (i=firstRowId; i<=(lastRowId); i++) {
      allSelected = allSelected && BMDGetElemById("CBS_" + i.toString()).checked;
    }

    if (allSelected) {
      selectedRows = null;
      for (i=firstRowId; i<=(lastRowId); i++) {
        try {
          //BMDGetElemById("CBS_" + i.toString()).checked = BMDGetElemById("CBS_" + i.toString()).checked ^ true;
          BMDGetElemById("CBS_" + i.toString()).checked = false;
        } catch (e) {
          if (GShowJSErrors) { alert("Exception in BMDMultiSelectAll:" + e.message); }
        }
      }
    } else {
      for (i=firstRowId; i<=(lastRowId); i++) {
        if (selectedRows == null) {
          selectedRows = new Array(i);
        } else {
          index = BMDGetArrayIndex(selectedRows, i);
          if (index == -1) {
            selectedRows.push(i);
          }
        }
        try {
          BMDGetElemById("CBS_" + i.toString()).checked = true;
        } catch (e) {
          if (GShowJSErrors) { alert("Exception in BMDMultiSelectAll:" + e.message); }
        }
      }
    }
  }
}

//*****************************************************************
// unterbricht browserunabhngig Eventkette
//*****************************************************************
function BMDCancelBubble(evt) {
  if (!evt) var evt = window.event;

  try {
    if(document.all){ //IE
      evt.cancelBubble = true;
    }
  } catch(e) {
    if (GShowJSErrors) { alert("Exception in BMDCancelBubble:" + e.message); }
  }

  try {
    if (evt.stopPropagation) { 
	  evt.stopPropagation();
	};
  } catch(e) {
    if (GShowJSErrors) { alert("Exception in BMDCancelBubble:" + e.message); }
  }

}

//*****************************************************************
// setzt Event zurck
//*****************************************************************
function BMDCancelEvent(evt) {
  if (!evt) var evt = window.event;

  try {
    BMDCancelBubble(evt);

    if(document.all){ //IE
      evt.keyCode = 0;
      evt.returnValue = false;
    }
  } catch(e) {
    if (GShowJSErrors) { alert("Exception in BMDCancelEvent:" + e.message); }
  }

  try {
    if (evt.preventDefault) { 
	  evt.preventDefault(); 
	};
  } catch(e) {
    if (GShowJSErrors) { alert("Exception in BMDCancelEvent:" + e.message); }
  }

  return false;
}

//*****************************************************************
// zentraler KeyDown-EventHandler fr das komplette Dokument
//*****************************************************************
function BMDHandleKeyPress(evt) {
var nbr, chr, elem, actRowId, firstRowId, lastRowId, newRowId, rowLimit, prefix, actKeyCode, actPointer, gridId, scrollDir;
  try {
    if (!evt) var evt = window.event;

    nbr = evt.keyCode;

    BMDSetHiddenFieldVal("CLICKEDCONTROL", "");

    actKeyCode = nbr;
    GKeyCode = actKeyCode;

    if (!GBlockCursor) {
      if (evt.shiftKey) {
        actKeyCode = actKeyCode + 1000;
      }
      if (evt.altKey) {
        actKeyCode = actKeyCode + 2000;
      }
      if (evt.ctrlKey) {
        if (actKeyCode == 65) {
          BMDMultiSelectAll();
          return BMDCancelEvent(evt);
        }
        actKeyCode = actKeyCode + 4000;
      }
      //wenn ShortCut in Array vorhanden wird Pointer in Delphi-Applikation zurckgeschickt
      if ((docShortcuts) && (docShortcuts["KC" + actKeyCode.toString()] != undefined)) {
        actPointer = docShortcuts["KC" + actKeyCode.toString()];
        //wenn mgliche aktuelle Controlwerte setzen
        elem = (evt.target) ? evt.target : evt.srcElement;

        if (elem) {
          try {
	    BMDSetChangedValue(elem);
            BMDSetHiddenFieldVal("ACTUALCONTROL", elem.id);
            BMDSetHiddenFieldVal("ACTUALCONTROLVAL", elem.value);
          } catch (e) {
            if (GShowJSErrors) { alert("Exception in BMDHandleKeyPress:" + e.message) };
          }
        }
        BMDStartDelphiAction(actPointer);
        return BMDCancelEvent(evt);

      } else if ( GActiveArrowNavigation && ((nbr==38) || (nbr==40) || (nbr==33) || (nbr==34)) ) {
        actRowId   = "";
        firstRowId = "";
        lastRowId  = "";
        //Hidden Fields auslesen------------------------------------------------------
        actRowId   = parseInt(BMDGetHiddenFieldVal("HDACTUALROWID"));
        firstRowId = parseInt(BMDGetHiddenFieldVal("HDFIRSTROWID"));
        lastRowId  = parseInt(BMDGetHiddenFieldVal("HDLASTROWID"));
        rowLimit   = parseInt(BMDGetHiddenFieldVal("HDROWLIMIT"));

        //neuen aktuellen Datensatz bestimmen-----------------------------------------------------
        if ((actRowId != NaN) && (actRowId >= firstRowId) && (actRowId <= lastRowId)) {
          BMDResetActualRow(actRowId);
          if (nbr==38) {                        //Pfeil oben
            newRowId = actRowId - 1;
            scrollDir = 1;
          } else if (nbr==40) {                 //Pfeil unten
            newRowId = actRowId + 1;
            scrollDir = 2;            
          } else if (nbr==33) {                 //PageUp
            newRowId = actRowId - rowLimit;
            scrollDir = 1;
          } else if (nbr==34) {                 //PageDown
            newRowId = actRowId + rowLimit;
            scrollDir = 2;            
          }

          BMDSetHiddenFieldVal("HDACTUALROWID", newRowId);
          if (selectedRows) {
            BMDSetHiddenFieldVal("SELECTEDROWS", selectedRows.join("|"));
          } else {
            BMDSetHiddenFieldVal("SELECTEDROWS", "");
          }

          elem     = BMDGetElemById(actRowId);
          gridId   = BMDGetGridIdForElem(elem);

          if (((newRowId < firstRowId) || (newRowId > lastRowId)) || GSendArrowNavToServer){
            GBlockCursor = true;
            SubmitClickConfirm(gridId, "NavTo_" + newRowId, true, "");
          } else {
            BMDScrollToRow(newRowId, gridId, scrollDir);
            BMDSetActualRow(newRowId);
          }
        }
        return false;
      //Funktionstasten abfangen!
      } else if ((Mod(actKeyCode, 4000) >= 112) && (Mod(actKeyCode, 4000) <= 123)) {
        return BMDCancelEvent(evt);
      } else {
        return true;
      }
    } else {
      return BMDCancelEvent(evt);
      return false;
    }
  } catch (e) {
    if (GShowJSErrors) { alert("Exception in BMDHandleKeyPress:" + e.message); }
  }
}

//*****************************************************************
// setzt Feldwert fr gewhlte Zeile beim Drcken eines Buttons in
// der Suchliste
//*****************************************************************
function BMDClickListSearchBtn() {
  SubmitClickConfirm("HDACTUALROWID", BMDGetHiddenFieldVal("HDACTUALROWID"), true, "");
  return false;
}

//*****************************************************************
// setzt Markierung in Liste fr genannte Zeile (Id) zurck
//*****************************************************************
function BMDResetActualRow(Id) {
var i, elem, elCol, elItem;
  elem = BMDGetElemById(Id);
  try {
    if (elem) {
      elCol = elem.childNodes;
      if (elCol) {
        for (i=0; i<(elCol.length); i++) {
          elItem = elCol[i];
          if (elItem) {
            elItem.style.backgroundColor = "";
          }
        }
      }
    }
  }
  catch (e) {
    if (GShowJSErrors) { alert("Exception in BMDResetActualRow:" + e.message); }
  }
}

//*****************************************************************
// setzt Markierung in Liste fr genannte Zeile (Id)
//*****************************************************************
function BMDSetActualRow(Id) {
var i, elem, elItem;
  elem = BMDGetElemById(Id);
  try {
    if (elem) {
      elCol = elem.childNodes;
      if (elCol) {
        for (i=0; i < (elCol.length); i++) {
          elItem = elCol[i];
          if (elItem) {
            elItem.style.backgroundColor = GSelectedRowColor;
          }
        }
      }
    }
  }
  catch (e) {
    //do nothing
  }
}

//*****************************************************************
// liefert TRUE falls das Element im Scrollbereich ist
//*****************************************************************
function isInScrollArea(elem, parentelem) {
  try {
    var parentViewTop = parentelem.scrollTop;
    var parentViewBottom = parentViewTop + parentelem.offsetHeight;

    var elemTop = elem.offsetTop - 40;
    var elemBottom = elemTop + elem.scrollHeight + 40;

    return ((elemBottom >= parentViewTop) && (elemTop <= parentViewBottom)
      && (elemBottom <= parentViewBottom) &&  (elemTop >= parentViewTop) );
  } catch (e) {
    //do nothing
  }
}

//*****************************************************************
// scrollt zur markierten Zeile
// scrollDir =1: Scroll zeilenweise nach oben
// scrollDir =2: Scroll zeilenweise nach unten
// scrollDir =3: Scroll genau auf Zeile
// scrollDir =4: Scroll auf die Zeile darber (fr Scroll auf erste Zeile
//               Tabellenheader bercksichtigen) 
//*****************************************************************
function BMDScrollToRow(Id, gridId, scrollDir) {
  var elem = BMDGetElemById(Id);
  if (elem) {
    var elGrid = BMDGetElemById(gridId);
    if (elGrid) {
      var divId = gridId.replace(/DBG/, "") + "PGRD";
      var elDiv = BMDGetElemById(divId);
      if (elDiv) {
        if (!isInScrollArea(elem, elDiv)) {
          try {
            if (scrollDir == 1) { //Scroll nach oben
              elDiv.scrollTop = elDiv.scrollTop - elem.scrollHeight;
            } else if (scrollDir == 2) {        //Scroll nach unten
              elDiv.scrollTop = elDiv.scrollTop + elem.scrollHeight;          
            } else if (scrollDir == 4) {        //Scroll nach unten
              elDiv.scrollTop = elem.offsetTop - elem.scrollHeight - 20;                    
            } else {  //genau auf Zeile scrollen
              elDiv.scrollTop = elem.offsetTop;              
            }
          } catch (e) {
            //do nothing
          }
        }
      }
    }
  }
}

//*****************************************************************
// setzt den Fokus auf Element mit Id (wird zeitverzgert aufge-
// rufen (sonst kann es zu Timing-Problemen kommen)
// ToDo: sichere Lsung fr das Problem finden
//*****************************************************************
function BMDSetFocusToName(Id) {
var elItem, elemFull;
  elItem = BMDGetElemById(Id);
  try {
    if (elItem) {
      elemFull = (elItem.value != '');
    } else {
      elemFull = false;
    }
  } catch (e) {
    if (GShowJSErrors) { alert("Exception in BMDSetFocusToName:" + e.message); }
  }
  try {
    if (elItem && elemFull) {
      setTimeout("BMDSetFocusToNameDelayed('" + Id + "', true)",  250);
    } else {
      setTimeout("BMDSetFocusToNameDelayed('" + Id + "', false)",  250);
    }
  } catch (e) {
    if (GShowJSErrors) { alert("Exception in BMDSetFocusToName:" + e.message); }
  }
}
//*****************************************************************
function BMDSetFocusToNameDelayed(Id, doSelect) {
var i, elItem = null, elemFull;
  elItem = BMDGetElemById(Id);
  if (elItem) {
    try {
      //ReleaseLock();
      elemFull = (elItem.value != '');
      elItem.focus();
      if (((elItem.type == "text") || (elItem.type == "password")) && elemFull) {    //nur befllte Textfelder auswhlen
      //if (((elItem.type == "text") || (elItem.type == "password")) && doSelect) {    //nur befllte Textfelder auswhlen
        elItem.select();
      }
    } catch (e) {
      if (GShowJSErrors) { alert("Exception in BMDSetFocusToNameDelayed:" + e.message); }
    }
    return true;
  } else {
    //alert("Setzen des Fokus auf " + name.toUpperCase() + " war nicht mglich!");
    return false;
  }
}

//******************************************************************************
// setzt KeyCode in IE - unter anderen Browsern funktioniert das noch nicht
//******************************************************************************
function BMDSetKeyCode(evt, keycode) {
  if (ie4) { //Prfung kommt aus IWCommon.js
    if (!evt) var evt = window.event;
    if (window.Event) {
      evt.which = keycode;
    } else {
      evt.keyCode = keycode;
    }
  }
}

//*****************************************************************
// fngt OnKeyDown-Events in Controls ab
//*****************************************************************
function BMDOnControlKeyDown(evt, sender, forcesubmit) {
var AKey, AElem;
  try {
    BMDSetHiddenFieldVal("CLICKEDCONTROL", "");

    if (!evt) var evt = window.event;

    AKey = evt.keyCode;

    GShiftState = 0;

    if (evt.shiftKey) {
      GShiftState = GShiftState + 1;
    }
    if (evt.altKey) {
      GShiftState = GShiftState + 2;
    }
    if (evt.ctrlKey) {
      GShiftState = GShiftState + 4;
    }

    if (GUseAjax) {       
      BMDSetHiddenFieldVal("HDKEYCODE", AKey);
      BMDSetHiddenFieldVal("HDSHIFTSTATE", GShiftState);   
   }    
    
    switch (AKey) {
      case 9:   //Tab************************************************
        GKeyCode = AKey;
        if (forcesubmit && !GUseAjax) {
          BMDSubmit(evt, sender);
		  return false;
        }
		else {
		  return true;	
		}
        break;
      case 13:  //Enter**********************************************
        GKeyCode = AKey;
        BMDSetKeyCode(evt, 9);
        if (forcesubmit && !GUseAjax)  {
          BMDSubmit(evt, sender);
		  return false;
        }
		else {
		  return true;	
        }
        break;
      case 115: //F4*************************************************
        GKeyCode = AKey;
        AElem = BMDGetElemById(sender.id + "BTNF4");
        //F4-Button klicken
        if (AElem != null) {
          try {
            BMDChangeFocus(sender, false, false);
            AElem.click();
          } catch (e) {
            if (GShowJSErrors) { alert("Exception in BMDOnControlKeyDown:" + e.message); }
          }
        }
        return BMDCancelEvent(evt);
      case 119: //F8*************************************************
        GKeyCode = AKey;
        AElem = BMDGetElemById(sender.id + "BTNF8");
        //F8-Button klicken
        if (AElem != null) {
          try {
            BMDChangeFocus(sender, false, false);
            AElem.click();
          } catch (e) {
            if (GShowJSErrors) { alert("Exception in BMDOnControlKeyDown:" + e.message); }
          }
        }
        return BMDCancelEvent(evt);
      default:
        GKeyCode = -1;
        return true;
    }
  } catch (e) {
    if (GShowJSErrors) { alert("Exception in BMDOnControlKeyDown:" + e.message); }
  }
}

//*****************************************************************
// steuert Klick und Doppelklick (JavaScript-Hack)
// wartet ob nach Abfeuern des Klick-Events in einer bestimmten Zeit
// (Timeout in ms) ein zweiter Klick (Doppelklick) erfolgt.
//*****************************************************************
function BMDSubmitClickConfirm(evt, objname, param, ADoValidation, AConfirmation, timeout) {
var elem = null;
var elemname;
var regEx;
var regExRes;

  BMDSetHiddenFieldVal("HDKEYCODE", GKeyCode);
  BMDSetHiddenFieldVal("HDSHIFTSTATE", GShiftState);
  if (selectedRows) {
    selectedRows.sort(sortNumber);
    BMDSetHiddenFieldVal("SELECTEDROWS", selectedRows.join("|"));
  } else {
    BMDSetHiddenFieldVal("SELECTEDROWS", "");
  }

  if (!evt) {var evt = window.event;}
  
  if (timeout == 0) {
    
    //CLICKEDCONTROL setzen damit im Inline-Edit bei Doppelklick Fokus auf Control gesetzt werden kann
    elem = (evt.target) ? evt.target : evt.srcElement;
   
    if ((elem) && (elem.id !== undefined)) {
        regEx = new RegExp('^[0-9]+_[0-9]+_(.*)$');
        if (regEx.test(elem.id)) {
          regExRes = regEx.exec(elem.id);
          try {
            elemname = regExRes[1];
            BMDSetHiddenFieldVal("CLICKEDCONTROL", elemname);    
            GMouseClicked = true;          
          } catch(e) {
          
          }
        }
    } else {
      BMDSetHiddenFieldVal("CLICKEDCONTROL", "");
      GMouseClicked = false;
    }
    window.clearTimeout(cltimer);
    SubmitClickConfirm(objname, param, ADoValidation, AConfirmation);
      } else {
    if (timeout < 400) {
      timeout = 400;
    }
    cltimer = setTimeout("SubmitClickConfirm('" + objname + "','" + param + "','" + ADoValidation + "','" + AConfirmation + "')", timeout);
  }
  return true;  
}

//*****************************************************************
// setzt Menu-Item-Stil
//*****************************************************************
function BMDSetMenuItemStyle(menuItemName, styleName) {
var elItem;
  elItem = BMDGetElemById(menuItemName);
  if (elItem) {
    try {
      elItem.className = styleName;
    } catch (e) {
      if (GShowJSErrors) { alert("Exception in BMDSetMenuItemStyle:" + e.message); }
    }
  }
}

function CreateOrModifyDiv(id, color, border, html, width, height, left, top) {
  var thediv;
  thediv = document.getElementById(id);
  if (!thediv) {
    thediv = document.createElement('div');
  } else {
    thediv.style.visibility = 'visible'; 
  }     
  thediv.setAttribute('id', id);
  if (width) {
    thediv.style.width = 300;
  }
  if (height) {
    thediv.style.height = 300;
  }
  if ((left || top) || (left && top)) {
    thediv.style.position = "absolute";
    if (left) {
      thediv.style.left = left;
    }
    if (top) {
      thediv.style.top = top;
    }
  }
  thediv.style.background = color;
  thediv.style.border = border;
  if (html) {
    thediv.innerHTML = html;
  } else {
    thediv.innerHTML = "nothing";
  }
  document.body.appendChild(thediv);
}
 
function HideDiv(id) {
  var thediv;
  thediv = document.getElementById(id);
  if (thediv) {
    thediv.style.visibility = 'hidden'; 
  }      
}

function BMDSelectRadioButton(name,selected){
  var elems=document.getElementsByName(name);
  var i;
  for (i=0;i<elems.length;i++){
    elems[i].checked=false;
  }
}

//*****************************************************************
// workaround - kommt sonst zu Javascriptfehlern bei IE 11
//*****************************************************************
function removeNS6SCDeadLock(sender) {
  return true;
}